;*******************************
;*    DEMONTRATION PROGRAM 5   *
;*        STEPPING MOTOR       *
;*******************************
;
            ORG    8000H
U28PA       EQU    0E0B4H
U28PB       EQU    0E0B5H
U28PC       EQU    0E0B6H
U28CTRL     EQU    0E0B7H
DISBUF      EQU    9F00H
SCAN_KYDP   EQU    27H
SCAND       EQU    25H
SCANK       EQU    26H
BCD_HEX     EQU    5               ;System call
CLRSCR      EQU    7               ;   "     "
HI_BEEP     EQU    18H             ;   "     "
ONE_TO_TWO  EQU    1DH             ;   "     "
TWO_IN_ONE  EQU    2EH             ;   "     "
WAIT_2KEY   EQU    33H             ;   "     "
GET_2KEY    EQU    12H             ;   "     "
HEX_2_SEG   EQU    15H
M_BUF1      EQU    23H
M_BUF2      EQU    M_BUF1+1
KEY_REPH    EQU    M_BUF1+2        ;Key repeat delay(hi)
KEY_REPL    EQU    M_BUF1+3        ;Key repeat delay(lo)
M_DELAYH    EQU    M_BUF1+4        ;Delay for pulse/phase
M_DELAYL    EQU    M_BUF1+5        ;
MX_VECTH    EQU    M_BUF1+6        ;Motor-X Vector hi byte
MX_VECTL    EQU    M_BUF1+7        ;low byte
MY_VECTH    EQU    M_BUF1+8        ;Motor-Y Vector hi byte
MY_VECTL    EQU    M_BUF1+9        ;low byte
PRG_PTRH    EQU    M_BUF1+10       ;Pointer of programing track
PRG_PTRL    EQU    M_BUF1+11       ;low byte
RUN_PTRH    EQU    M_BUF1+12       ;Pointer of Auto track(hi)
RUN_PTRL    EQU    M_BUF1+13       ;low byte

KEY_STAT    EQU    10H             ;Bit addressable
REPEAT      EQU    11H             ;Bit addressable
SYSCALL     EQU    0030H           ; System call

CP3DEM5:    MOV    DPTR,#U28CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A
            MOV    PSW,#0
            MOV    MX_VECTH,#0
            MOV    MX_VECTL,#0
            MOV    MY_VECTH,#0
            MOV    MY_VECTL,#0
            MOV    DPTR,#MX_DATA      ;Initial data pointer
            MOV    PRG_PTRL,DPL
            MOV    PRG_PTRH,DPH
            CLR    A
            MOVX   @DPTR,A
            INC    DPTR
            MOVX   @DPTR,A
            MOV    DPTR,#U28PB        ;Activate step motor
            MOV    A,#33H
            MOVX   @DPTR,A
            LCALL  DELAY2
            RL     A
            MOV    M_BUF1,A
            MOV    M_BUF2,A
            MOVX   @DPTR,A
            LCALL  DELAY2
            CLR    A
            MOVX   @DPTR,A

STR2:       MOV    A,#SCANK            ;Waiting for keyboard
            LCALL  SYSCALL
            CJNE   A,#0FFH,STR3
            CLR    KEY_STAT
            CLR    REPEAT              ;Auto repeat key
            MOV    KEY_REPH,#0F0H      ;Delay of auto repeat
            MOV    KEY_REPL,#0
            SJMP   STR2
STR3:       JB     REPEAT,STR5
            JNB    KEY_STAT,STR4
            MOV    DPH,KEY_REPH
            MOV    DPL,KEY_REPL
            INC    DPTR                ;advance counter
            MOV    KEY_REPH,DPH
            MOV    KEY_REPL,DPL
            MOV    B,A                 ;Save key code
            MOV    A,DPH
            ORL    A,DPL
            JNZ    STR2                ;Hold key until time out
            MOV    M_DELAYH,#0F7H      ;Increase speed of motor
            MOV    M_DELAYL,#0
            SETB   KEY_STAT
            SETB   REPEAT
            MOV    A,B                 ;Return key code
            SJMP   STR5
STR4:       SETB   KEY_STAT
            MOV    M_DELAYH,#0A0H
            MOV    M_DELAYL,#0
STR5:       CJNE   A,#1,DEC_MX
            SJMP   INC_MX         ;Clockwise turn motor-X
DEC_MX:     CJNE   A,#0,INC_MY
            SJMP   DEC_MX1        ;Counter Clockwise turn motor-X
INC_MY:     CJNE   A,#3,DEC_MY
            LJMP   INC_MY2        ;Clockwise turn motor-Y
DEC_MY:     CJNE   A,#2,REC
            LJMP   DEC_MY2        ;Counter Clockwise turn motor-X
REC:        CJNE   A,#10H,AUT
            LCALL  RECORD         ;Programming track
            LJMP   STR2
AUT:        CJNE   A,#11H,STR2
            LCALL  AUTO           ;Auto track
            LJMP   STR2
            ;*
            ;*Motor X-axis Go Forward (Manual)
            ;*
INC_MX:     MOV    A,M_BUF1
            MOV    DPTR,#U28PB
            ANL    A,#0FH
            MOVX   @DPTR,A
            JB     REPEAT,IM1
            MOV    R2,#0FFH
            DJNZ   R2,$
IM1:        MOV    A,M_BUF1
            RL     A
            MOV    M_BUF1,A
            ANL    A,#0FH
            MOV    DPTR,#U28PB
            MOVX   @DPTR,A
            LCALL  DELAY
            CLR    A
            MOVX   @DPTR,A
            INC    MX_VECTL
            MOV    A,MX_VECTL
            JNZ    IM2
            INC    MX_VECTH
IM2:        LJMP   STR2
            ;*
            ;*Motor X-axis Go Backward (Manual)
            ;*
DEC_MX1:    MOV    A,M_BUF1
            MOV    DPTR,#U28PB
            ANL    A,#0FH
            MOVX   @DPTR,A
            JB     REPEAT,DM1
            MOV    R2,#0FFH
            DJNZ   R2,$
DM1:        MOV    A,M_BUF1
            RR     A
            MOV    M_BUF1,A
            ANL    A,#0FH
            MOV    DPTR,#U28PB
            MOVX   @DPTR,A
            LCALL  DELAY
            CLR    A
            MOVX   @DPTR,A
            MOV    A,MX_VECTL
            JNZ    DM2
            DEC    MX_VECTH
DM2:        DEC    MX_VECTL
            LJMP   STR2
            ;*
            ;*Motor Y-axis Go Forward (Manual)
            ;*
INC_MY2:    MOV    A,M_BUF2
            MOV    DPTR,#U28PB
            ANL    A,#0F0H
            MOVX   @DPTR,A
            JB     REPEAT,IMY1
            MOV    R2,#0FFH
            DJNZ   R2,$
IMY1:       MOV    A,M_BUF2
            RL     A
            MOV    M_BUF2,A
            ANL    A,#0F0H
            MOV    DPTR,#U28PB
            MOVX   @DPTR,A
            LCALL  DELAY
            CLR    A
            MOVX   @DPTR,A
            INC    MY_VECTL
            MOV    A,MY_VECTL
            JNZ    IMY2
            INC    MY_VECTH
IMY2:       LJMP   STR2
            ;*
            ;*Motor Y-axis Go Backward (Manual)
            ;*
DEC_MY2:    MOV    A,M_BUF2
            MOV    DPTR,#U28PB
            ANL    A,#0F0H
            MOVX   @DPTR,A
            JB     REPEAT,DMY3
            MOV    R2,#0FFH
            DJNZ   R2,$
DMY3:       MOV    A,M_BUF2
            RR     A
            MOV    M_BUF2,A
            ANL    A,#0F0H
            MOV    DPTR,#U28PB
            MOVX   @DPTR,A
            LCALL  DELAY
            CLR    A
            MOVX   @DPTR,A
            MOV    A,MY_VECTL
            JNZ    DMY4
            DEC    MY_VECTH
DMY4:       DEC    MY_VECTL
            LJMP   STR2

;****************************
;* Record programed track   *
;****************************
; Data structur  :-
; loc   ->  Vector of motor-X (low byte)
; loc+1 ->  Vector of motor-X (hi byte)
; loc+2 ->  Vector of motor-Y (low byte)
; loc+3 ->  Vector of motor-Y (hi byte)
;
RECORD:     MOV    DPH,PRG_PTRH    ;Get pointer
            MOV    DPL,PRG_PTRL
            MOV    A,MX_VECTL
            MOVX   @DPTR,A         ;Save vector of motor-X (lo)
            INC    DPTR
            MOV    A,MX_VECTH
            MOVX   @DPTR,A         ;Save vector of motot-X (hi)
            INC    DPTR
            MOV    A,MY_VECTL
            MOVX   @DPTR,A         ;Save vector of motor-Y (lo)
            INC    DPTR
            MOV    A,MY_VECTH
            MOVX   @DPTR,A         ;Save vector of motor-Y (hi)
            INC    DPTR            ;Point to next record
            MOV    PRG_PTRH,DPH    ;Save pointer
            MOV    PRG_PTRL,DPL
            CLR    A
            MOV    MX_VECTL,A      ;Clear tempolary vector
            MOV    MX_VECTH,A
            MOV    MY_VECTL,A
            MOV    MY_VECTH,A
OUT_REC:    RET

;****************************
;*         Auto track       *
;****************************
;
AUTO:       MOV    DPTR,#MX_DATA    ;Point to 1st.record
            MOV    RUN_PTRL,DPL
            MOV    RUN_PTRH,DPH
AUTO1:      MOV    DPL,RUN_PTRL     ;start 1st.record
            MOV    DPH,RUN_PTRH
            MOVX   A,@DPTR          ;low byte
            MOV    B,A
            MOV    R2,A
            INC    DPTR
            MOVX   A,@DPTR          ;high byte
            MOV    R3,A             ;R3:R2 = round count
            INC    DPTR             ;Advance to next record
            MOV    RUN_PTRL,DPL     ;Save to pointer buffer
            MOV    RUN_PTRH,DPH
            ORL    A,B              ;is data or not ?
            JZ     TRACK_Y          ;No data,process motor-Y
            LCALL  MOTOR_X          ;Run motor-X
TRACK_Y:    MOV    DPL,RUN_PTRL
            MOV    DPH,RUN_PTRH
TRACK_Y1:   MOVX   A,@DPTR
            MOV    R2,A
            MOV    B,A
            INC    DPTR
            MOVX   A,@DPTR
            MOV    R3,A
            INC    DPTR
            MOV    RUN_PTRL,DPL
            MOV    RUN_PTRH,DPH
            ORL    A,B
            JZ     NXT_DAT
            LCALL  MOTOR_Y        ;Run motor-Y

NXT_DAT:    MOV    A,#HI_BEEP
            LCALL  SYSCALL
            MOV    A,RUN_PTRL     ;If RUN pointer = PRG point
            XRL    A,PRG_PTRL     ;then end else process next
            JNZ    AUTO1
            MOV    A,RUN_PTRH
            XRL    A,PRG_PTRH
            JNZ    AUTO1
OUT_AUTO:   MOV    DPTR,#MX_DATA
            MOV    PRG_PTRL,DPL
            MOV    PRG_PTRH,DPH
            CLR    A
            MOVX   @DPTR,A
            INC    DPTR
            MOVX   @DPTR,A
            INC    DPTR
            MOVX   @DPTR,A
            INC    DPTR
            MOVX   @DPTR,A
            RET

;*********************************
;* Turn motor-X to left or right *
;* Input    : R3:R2 Round count  *
;*            (-32768 to 32767)  *
;*********************************
;
MOTOR_X:    MOV    A,R3
            JB     ACC.7,TRCK_BACK
TRCK_FWD:   MOV    A,#M_BUF1        ;Phase buffer
            MOV    B,#0FH           ;Motor #1
            LCALL  GOTO_X
            MOV    A,R2
            JNZ    DEC_R2
            MOV    A,R3
            JZ     OUT_MOTORX
            DEC    R3
DEC_R2:     DEC    R2
            MOV    A,R2
            ORL    A,R3
            JNZ    TRCK_FWD
            SJMP   OUT_MOTORX
TRCK_BACK:  LCALL  COMPMNT_2
TRCK_BCK1:  MOV    A,#M_BUF1       ;Phase buffer
            MOV    B,#0FH          ;Motor #1
            LCALL  GOBACK_X
            MOV    A,R2
            JNZ    DEC_R21
            MOV    A,R3
            JZ     OUT_MOTORX
            DEC    R3
DEC_R21:    DEC    R2
            MOV    A,R2
            ORL    A,R3
            JNZ    TRCK_BCK1
OUT_MOTORX: RET


;*********************************
;* Turn motor-Y to left or right *
;* Input    : R3:R2 Round count  *
;*            (-32768 to 32767)  *
;*********************************
;
MOTOR_Y:    MOV    A,R3
            JB     ACC.7,TRCK_BACK2  ;Clockwise turn motor-Y
TRCK_FWD2:  MOV    A,#M_BUF2         ;Phase buffer
            MOV    B,#0F0H           ;Motor #2
            LCALL  GOTO_X
            MOV    A,R2
            JNZ    DEC_R2Y
            MOV    A,R3
            JZ     OUT_MOTORY
            DEC    R3
DEC_R2Y:    DEC    R2
            MOV    A,R2
            ORL    A,R3
            JNZ    TRCK_FWD2
            SJMP   OUT_MOTORY
TRCK_BACK2: LCALL  COMPMNT_2
TRCK_BK21:  MOV    A,#M_BUF2         ;Phase buffer
            MOV    B,#0F0H           ;Motor #2
            LCALL  GOBACK_X
            MOV    A,R2
            JNZ    DEC_R21Y
            MOV    A,R3
            JZ     OUT_MOTORY
            DEC    R3
DEC_R21Y:   DEC    R2
            MOV    A,R2
            ORL    A,R3
            JNZ    TRCK_BK21
OUT_MOTORY: RET


;***************************************
;* Sub routine 16 bit Two's complement *
;* Input    :R3:R2 = Integer           *
;* Output   :R3:R2                     *
;***************************************
;
COMPMNT_2:  MOV    A,R3
            CPL    A                ;One's complement
            MOV    R3,A
            MOV    A,R2
            CPL    A
            ADD    A,#1             ;Two's complement
            MOV    R2,A
            JNC    OUT_CMP
            MOV    A,#0
            ADDC   A,R3
            MOV    R3,A
OUT_CMP:    RET

;************************************
;* Sub routine turn motor clockwise *
;* Input    : ACC = Address of Motor*
;*            buffer 1 or 2         *
;*            B   = 0FH  = Motor-X  *
;*            B   = 0F0H = Motor-Y  *
;************************************
;
GOTO_X:     MOV    R0,A        ;ACC point to addr. of variable
            MOV    A,@R0       ;Get old phase
            RL     A           ;turn motor to clockwise
            MOV    @R0,A       ;Save to it's place
            ANL    A,B
            MOV    DPTR,#U28PB
            MOVX   @DPTR,A     ;Activate phase
            LCALL  DELAY2      ;Pusle hi delay
            CLR    A
            MOVX   @DPTR,A
            RET
;*
;* Sub routine turn motor counter clockwise
;*
GOBACK_X:   MOV    R0,A        ;ACC point to addr. of variable
            MOV    A,@R0       ;Get old phase
            RR     A           ;turn motor to clockwise
            MOV    @R0,A       ;Save to it's place
            ANL    A,B
            MOV    DPTR,#U28PB
            MOVX   @DPTR,A     ;Activate phase
            LCALL  DELAY2      ;Pulse hi delay
            CLR    A
            MOVX   @DPTR,A
            RET
;*
;* Vary duration delay
;*
DELAY:      PUSH   DPL
            PUSH   DPH
            PUSH   ACC
            MOV    DPH,M_DELAYH
            MOV    DPL,M_DELAYL
DLY1:       INC    DPTR
            MOV    A,DPL
            ORL    A,DPH
            JNZ    DLY1
            POP    ACC
            POP    DPH
            POP    DPL
            RET
;*
;* Delay routine for auto track
;*
DELAY2:     PUSH   DPL
            PUSH   DPH
            PUSH   ACC
            MOV    DPTR,#0F700H
DLY21:      INC    DPTR
            MOV    A,DPL
            ORL    A,DPH
            JNZ    DLY21
            POP    ACC
            POP    DPH
            POP    DPL
            RET

            ;*Buffer of motor track programing

MX_DATA:    DB     0      ;Auto track data (Up to end)

            END
